//
//  IHRWIFIManager.h
//
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

typedef void(^IHRWIFIManagerReceiveCallBackBlock)(NSData *data);

@class IHRWIFIManager;
@protocol IHRWIFIManagerDelegate <NSObject>
@optional
/**
 * connect success
*/
- (void)IHRwifiConnectedToHost:(NSString *)host port:(UInt16)port;
/**
 * disconnect error
*/
- (void)IHRwifiDisconnectWithError:(NSError *)error;
/**
 * disconnect manual
*/
- (void)IHRwifiDisconnectForManual;
/**
 * send data success
*/
- (void)IHRwifiWriteValueWithTag:(long)tag;
/**
 * receive printer data
 */
- (void)IHRwifiReceiveValueForData:(NSData *)data;
@end

@interface IHRWIFIManager : NSObject
// host
@property (nonatomic, copy) NSString *hostStr;
// port
@property (nonatomic, assign) UInt16 port;
// whether connect
@property (nonatomic, assign) BOOL isConnect;

@property (nonatomic, weak) id<IHRWIFIManagerDelegate> delegate;

@property (nonatomic, copy) IHRWIFIManagerReceiveCallBackBlock receiveBlock;

/**
 *  singleton
*/
+ (instancetype)sharedInstance;
/**
 * connect printer address
*/
-(void)connectWithHost:(NSString *)hostStr port:(UInt16)port;
/**
 * disconnect
*/
- (void)disconnect;
/**
 *  write command to printer
*/
-(void)writeCommandWithData:(NSData *)data;
/**
 * remove a delegate
*/
- (void)removeDelegate:(id<IHRWIFIManagerDelegate>) delegate;
/**
 * remove all delegates
*/
- (void)removeAllDelegates;
/**
 *  query printer data
 */
- (void)getPrinterData:(IHRWIFIManagerReceiveCallBackBlock)receiveBlock;

@end
